@echo off
setlocal
cd /d "%~dp0"

echo 🚀 Starting Discord VC Manager...

:: Port clearing (Constraint Convergence: Auto-resolve technical hurdle)
echo 🔍 Checking for existing process on port 3001...
for /f "tokens=5" %%a in ('netstat -aon ^| findstr :3001 ^| findstr LISTENING') do taskkill /F /PID %%a >nul 2>&1

:: Environment Check (Constraint Convergence: Portability)
where node >nul 2>&1
if %errorlevel% neq 0 (
    echo ❌ Error: Node.js is not installed.
    echo Please install Node.js from https://nodejs.org/
    pause
    exit /b
)

if not exist "node_modules\" (
    echo 📦 Dependencies missing. Running npm install...
    cmd /c "npm install"
)

echo 📋 Opening browser in 3 seconds...

:: Open the browser in the background
start "" "http://localhost:3001"

:: Start the node server
:: Using cmd /c to ensure npm works correctly in some environments
cmd /c "npm run dev"

pause
