require('dotenv').config();

const client = require('./bot');
const createServer = require('./server');

// Validate environment variables
if (!process.env.DISCORD_TOKEN) {
    console.error('❌ DISCORD_TOKEN is not set in .env file');
    console.error('   Please copy .env.example to .env and set your Discord bot token');
    process.exit(1);
}

if (!process.env.GUILD_ID) {
    console.error('❌ GUILD_ID is not set in .env file');
    console.error('   Please set your Discord server ID in .env file');
    process.exit(1);
}

const PORT = process.env.PORT || 3001;

// Start the bot and server
async function start() {
    try {
        // Login to Discord
        await client.login(process.env.DISCORD_TOKEN);

        // Create and start the Express server
        const server = createServer(client, process.env.GUILD_ID);

        server.listen(PORT, () => {
            console.log(`🚀 Server running at http://localhost:${PORT}`);
            console.log(`📋 API endpoints:`);
            console.log(`   GET  /api/channels     - List voice channels`);
            console.log(`   GET  /api/members      - List members in voice channels`);
            console.log(`   GET  /api/all-channels - List all voice channels for move target`);
            console.log(`   POST /api/move         - Move members to a channel`);
            console.log(`   POST /api/mute         - Mute members`);
            console.log(`   POST /api/unmute       - Unmute members`);
        });
    } catch (error) {
        console.error('❌ Failed to start:', error.message);
        process.exit(1);
    }
}

start();
