const { Client, GatewayIntentBits, Events, ActivityType } = require('discord.js');

// Create Discord client with required intents
const client = new Client({
  intents: [
    GatewayIntentBits.Guilds,
    GatewayIntentBits.GuildVoiceStates,
    // GatewayIntentBits.GuildMembers, // Removed as it is a privileged intent
  ],
});

// Bot ready event
client.once(Events.ClientReady, (readyClient) => {
  console.log(`✅ Bot logged in as ${readyClient.user.tag}`);

  // サーバーのURLをステータスに表示
  readyClient.user.setActivity('VC管理ツール', {
    type: ActivityType.Watching,
    url: process.env.APP_URL || 'http://localhost:3001'
  });
});

// Voice state update event (for real-time updates)
client.on(Events.VoiceStateUpdate, (oldState, newState) => {
  // This event will be used by server.js for Socket.io updates
  client.emit('voiceUpdate', { oldState, newState });
});

module.exports = client;
