# Discord VC Manager セットアップガイド

このツールをダウンロードしていただきありがとうございます！
このガイドでは、自分のサーバーでこの管理ツールを動かすための手順を説明します。

---

## 📋 準備するもの
- **Node.js**: プログラムを実行するために必要です。
  - [nodejs.org](https://nodejs.org/) から「LTS版」をインストールしてください。
- **Discordアカウント**: ボットを作成するために必要です。

---

## 🛠️ セットアップ手順

### 1. Discord Botの作成とトークンの取得
1.  **[Discord Developer Portal](https://discord.com/developers/applications)** にアクセスします。
2.  **「New Application」** を押し、適当な名前（例: VC Manager）を付けて作成します。
3.  左メニューの **「Bot」** をクリックします。
4.  **「Reset Token」** を押し、表示された文字列をコピーしてメモしておきます（これが `DISCORD_TOKEN` になります）。
5.  同じ画面の少し下にある **「Privileged Gateway Intents」** の項目で、以下の3つをすべて **ON** にします：
    - Presence Intent
    - Server Members Intent
    - Message Content Intent
    - ※最後に「Save Changes」を忘れずに！

### 2. Botをサーバーに招待する
1.  左メニューの **「OAuth2」>「URL Generator」** を開きます。
2.  **Scopes** で `bot` にチェックを入れます。
3.  **Bot Permissions** で以下にチェックを入れます：
    - Move Members（メンバーを移動）
    - Mute Members（メンバーをミュート）
    - View Channels（チャンネルを見る）
4.  下部に生成されたURLをコピーしてブラウザで開き、自分のサーバーにボットを追加します。

### 3. 設定ファイル（.env）の作成
1.  ダウンロードしたフォルダにある `.env.example` をコピーして、名前を **`.env`** に変更します。
2.  `.env` ファイルをメモ帳などで開き、以下の情報を記入します：
    - `DISCORD_TOKEN`: 先ほどコピーしたトークン
    - `GUILD_ID`: ボットをいれたサーバーのID
      - （サーバー名を右クリック > 「IDをコピー」で取得できます。表示されない場合は、Discordの設定 > 詳細設定 > 開発者モードをONにしてください）
    - `APP_URL`: 自分のWebサイトなどがあれば記入（空欄でもOK）

### 4. 起動
1.  フォルダ内の **`start.bat`** をダブルクリックします。
2.  初回起動時は必要な部品が自動でダウンロードされます。
3.  ブラウザが自動で開き、管理画面が表示されたら完了です！

---

## ❓ 困ったときは
- **「コマンドが見つかりません」**: Node.jsが正しくインストールされているか確認してください。
- **「Invalid Token」**: `.env` に貼り付けたトークンが正しいか、余計なスペースが入っていないか確認してください。
- **メンバーが移動できない**: ボットの「ロール」が、移動させたい人よりも上の位置にある必要があります。
