# Discord VC Manager

DiscordのボイスチャンネルをWeb GUIから操作できるツールです。

## 機能

- 🔊 **VC可視化** - ボイスチャンネルにいるメンバーを一覧表示
- 👥 **複数選択** - チェックボックスで複数のメンバーを選択
- ➡️ **一括移動** - 選択したメンバーを別のVCに一括移動
- 🔇 **一括ミュート** - 選択したメンバーを一括ミュート/ミュート解除
- ⚡ **リアルタイム更新** - VC状態の変更をリアルタイムで反映

## セットアップ

### 1. Discord Botの作成

1. [Discord Developer Portal](https://discord.com/developers/applications) にアクセス
2. 「New Application」をクリック
3. アプリケーション名を入力して作成
4. 左メニューから「Bot」を選択
5. 「Add Bot」をクリック
6. 「Reset Token」をクリックしてトークンをコピー

### 2. Botの権限設定

1. 左メニューから「OAuth2 > URL Generator」を選択
2. Scopesで `bot` を選択
3. Bot Permissionsで以下を選択:
   - Move Members
   - Mute Members
   - View Channels
4. 生成されたURLをコピーしてブラウザで開き、サーバーに招待

### 3. 環境変数の設定

```bash
# .env.exampleをコピー
cp .env.example .env
```

`.env`ファイルを編集:

```
DISCORD_TOKEN=your_bot_token_here
GUILD_ID=your_server_id_here
PORT=3001
```

**サーバーIDの取得方法:**
1. Discordで「ユーザー設定 > 詳細設定」から開発者モードを有効化
2. サーバー名を右クリック > 「IDをコピー」

### 4. 起動

#### 方法A: かんたん起動 (Windows)
プロジェクトディレクトリにある `start.bat` をダブルクリックします。
- 自動的にサーバーが起動し、ブラウザで管理画面が開きます。

#### 方法B: コマンドラインで起動
```bash
# 依存関係をインストール (初回のみ)
npm install

# 起動
npm run dev
```

### 5. アクセス

ブラウザで [http://localhost:3001](http://localhost:3001) にアクセス

## 使い方

1. **メンバーを選択**: チェックボックスをクリックして選択
2. **移動**: 移動先を選択して「移動」ボタンをクリック
3. **ミュート**: 選択して「ミュート」ボタンをクリック
4. **ミュート解除**: 選択して「ミュート解除」ボタンをクリック

## トラブルシューティング

### Botが接続できない

- `DISCORD_TOKEN`が正しく設定されているか確認
- Botがサーバーに招待されているか確認

### 移動/ミュートができない

- Botに「Move Members」「Mute Members」権限があるか確認
- Botのロールがターゲットユーザーのロールより上位にあるか確認

### メンバーが表示されない

- `GUILD_ID`が正しく設定されているか確認
- Botに「View Channels」権限があるか確認
